program Gauss;

{ LSD, BFG, PHP. }
uses Crt; 

{ Maximalni pocet rovnic, na dynamicky alokace si tu nehrajeme :) }
const MaxM = 10;

{ Maximalni pocet rovnic. }
const MaxN = 10;

{ Jak formatovat vystup: pocet cislic pred a za desetinnou carkou. }
const Vystup_MistPredTeckou = 3;
const Vystup_MistZaTeckou = 3;

var
	{ Pocet rovnic, pocet neznamych. }
	M, N : integer;

	{ Koeficienty, prvni index je radek, druhy sloupec. Sloupec pravych
		hodnot je sloupec N. }
	Matice : array [1..MaxM, 1..MaxN] of real;

{ ====================================================================== }
{ ====================================================================== }
{ ====================================================================== }

{ Kdo maze, ten jede. }

procedure Intro;
begin
  ClrScr;
end;

{ ====================================================================== }

{ Kdyby nekdo chtel nacitat matici pres konzoli misto ze souboru, necht 
  v hlavnim programu nahradi volani funkce NactiMaticiZeSouboru() 
 	funkci touto.	}

procedure NactiMatici;
var
	i, j : integer;

begin

	{ Optame se. }
	Write('Rovnic: '); ReadLn(M);
	Write('Promennych: '); ReadLn(N);

	{ Pridame sloupec pravych hodnot. }
  Inc(N);

	for i := 1 to M do
	begin
		for j := 1 to N-1 do Read(Matice[i,j]);
		ReadLn(Matice[i,N]);
	end;

	WriteLn;
end;

{ ====================================================================== }

{ Nacte rozsirenou matici soustavy ze souboru 'JmenoSouboru'. Pokud obsahuje
	tento parametr prazdny retezec, zobrazi funkce v konzoli vyzvu k zadani
	jmena souboru, ktery se ma nacist.

	Na prvnim radku souboru musi byt uveden pocet neznamych. Na dalsich radcich
	pak nasleduji hodnoty matice, v ramci radku oddelene mezerami. }

procedure NactiMaticiZeSouboru ( JmenoSouboru : string );
var
	Soubor : Text;
	i, j : integer;

begin
	while JmenoSouboru = '' do
	begin
		Write('Zadejte jmeno souboru: ');
		ReadLn(JmenoSouboru);
	end;

	Assign(Soubor, JmenoSouboru);
	Reset(Soubor);

	ReadLn(Soubor, N); Inc(N);
	M := 0;

	while not EoF(Soubor) do
	begin
		Inc(M);
		for	i := 1 to N-1 do Read(Soubor, Matice[M, i]);
		ReadLn(Soubor, Matice[M, N]);
	end;

	Close(Soubor);
end;

{ ====================================================================== }

{ Hrani si s vystupem, aby vypadal trochu k svetu. }

procedure VypisMatici;
var
	Vystup : string;
	i, j : integer;

begin
	for i := 1 to M do
	begin
		Write('(');
		for j := 1 to N do 
		begin
			Str(Matice[i,j]:Vystup_MistPredTeckou:Vystup_MistZaTeckou, Vystup);
			if Matice[i,j] >= 0 then Vystup := ' ' + Vystup;
			Write(Vystup, ' ');

			if j = N-1 then Write(' | ');
		end;
		WriteLn(')');
	end;
	WriteLn;
end;

{ ====================================================================== }

{ Vynasobi vsechny koeficienty v radku 'Radek' konstantou 'k'. }

procedure VynasobRadek ( Radek : integer; k : real );
var
  i : integer;

begin
  for i := 1 to N do
		Matice[Radek, i] := Matice[Radek, i] * k;
end;

{ ====================================================================== }

{ Pricte koeficienty radku 'a' vynasobene konstatou 'k' k radku 'b'. }

procedure PrictiRadek ( a, b, k : integer);
var
  i : integer;

begin
  for i := 1 to N do
		Matice[b,i] := Matice[b,i] + Matice[a,i]*k;
end;

{ ====================================================================== }

{ Prohodi radky 'a' a 'b'. }

procedure ProhodRadky ( a, b : integer );
var
	i : integer;
	x : real;

begin
  if a = b then exit;

	for i := 1 to N do
  begin
		x := Matice[a,i];
		Matice[a,i] := Matice[b,i];
		Matice[b,i] := x;
	end;
end;

{ ====================================================================== }

{ Upravi koeficienty v matici tak, aby byla matice v odstupnovanem 
  tvaru. }

procedure UpravMaticiNaOdstupnovanyTvar;
var
  i, j, k, p  : integer;
	Mij, Mpj : real;
	Hotovo : boolean;

begin
  for i := 1 to M-1 do
	begin
    Hotovo := False; j := 0;
		while not Hotovo do
		begin
			Inc(j);
			if Matice[i,j] <> 0 then
				Hotovo := True
			else
				for p := i+1 to M do
					if Matice[p,j] <> 0 then
						begin Hotovo := True; k := p; end;
		end;

		if Matice[i,j] = 0 then
		  ProhodRadky(i, k)
		else
			for p := i+1 to M do
				if Matice[p,j] <> 0 then
					begin
						Mij := Matice[i,j];
						Mpj := Matice[p,j];
						VynasobRadek(i, Mpj);
						VynasobRadek(p, Mij);
						PrictiRadek(i, p, -1);
						VynasobRadek(i, 1 / Mpj);
					end;
	end;
end;

{ ====================================================================== }

{ Pokud existuje reseni soustavy rovnic, vypise se. Pokud jich existuje
  nekonecne mnoho, vypisi se vektory, ktere jsou systemem generatoru
  vektoroveho prostoru ker(Matice). Pokud reseni neexistuje, vypise se,
	ze reseni neexistuje.

	Predpoklada se, ze matice uz je v odstupnovanem tvaru. }

procedure VypisReseni;
var
	{ Promenna 'i' figuruje jako pivot v radku 'Pivoty[i]'. Pokud je promenna
		'i' volna, 'Pivoty[i]' se rovna nule. }
	Pivoty : array[1..MaxN] of integer;

  { Pocet nenulovych radku. }
	r : integer;

	{}
  i, j, k : integer;

	{ Reseni[i][j] udava koeficient, kterym vynasobena se volna
	  promenna 'j' podili na vyjadreni promenne 'i'.

		Reseni[i][N] uklada konstatni clen. }
	Reseni : array[1..MaxN, 1..MaxN] of real;

	{ Retezec k formatovani vystupu. }
	Vystup : string;

begin

	{ Urcime bazove a volne promenne a pokud existuje pivot ve sloupci
	pravych hodnot, vypiseme, ze reseni neexistuje. }

  for i := 1 to N do Pivoty[i] := 0;
	j := 1;
	r := M;

	for i := 1 to M do
	begin
		while (Matice[i,j] = 0) and (j <= N) do Inc(j);
		if j > N
			then r := i-1
		else
			Pivoty[j] := i;
	end;

	if Pivoty[N] > 0 then
	begin
		WriteLn('Soustava nema reseni.');
		exit;
	end
	else
		for i := 1 to N-1 do
		begin
			Write('Promenna ', i, ' je ');
			if Pivoty[i] > 0 then WriteLn('bazova a ma pivot v radku ', Pivoty[i], '.') else WriteLn('volna.');
		end;

	{ Vyjadrime kazdou promennou jako linearni kombinaci volnych promennych
	a konstanty. }

	for i := 1 to N do
		for j := 1 to N do Reseni[i,j] := 0;

	for i := N-1 downto 1 do
	begin
		if Pivoty[i] = 0 then
			Reseni[i, i] := 1
		else
		begin
			for j := i+1 to N-1 do
				for k := 1 to N do
					if Matice[Pivoty[i], j] <> 0 then 
						Reseni[i,k] := Reseni[i,k] -
							Matice[Pivoty[i], j] / Matice[Pivoty[i], i] * Reseni[j,k];
			Reseni[i,N] := Reseni[i,N] + Matice[Pivoty[i], N] / Matice[Pivoty[i], i];
		end;
	end;

	{ Vypis. }

	WriteLn;

	for i := 1 to N-1 do 
	begin
		k := 0;

		if i = N div 2 then Write('Reseni = ') 
		               else Write('         ');

		for j := 1 to N do
			if (j = N) or (Pivoty[j] = 0) then
			begin
				Inc(k);
				if j <> N then if i = N div 2 then Write('p', k, ' ')
                                      else Write('   ');

				Str(Reseni[i,j]:Vystup_MistPredTeckou:Vystup_MistZaTeckou, Vystup);
				if Reseni[i,j] >= 0 then Vystup := ' ' + Vystup;
				Write('( ', Vystup, ' )');

				if (i = N div 2) and (j <> N) then Write(' + ')
                                      else Write('   ');
			end;

		WriteLn;
	end;
end;

{ ====================================================================== }
{ ====================================================================== }
{ ====================================================================== }

BEGIN
	Intro;
	NactiMaticiZeSouboru('Matice.txt');

	WriteLn('Zadana matice: ');
	VypisMatici;

	UpravMaticiNaOdstupnovanyTvar;
	WriteLn('V odstupnovanem tvaru: ');
	VypisMatici;

	VypisReseni;

	ReadLn;
END.

