{	Tohle jsem dostal u zapoctovyho testu. Je to klasickej pripad na 
	Breadth-First Search (prohledavani do sirky):

	Na sachovnici velikosti M x N najdete cestu mezi dvema zadanymi poli, 
	pricemz pohybovat se muzete a la sachovy strelec. Nektera pole jsou 
 	navic zakazana a pres takova pole cesta vest nesmi.	
	
	Na vstupu ocekavejte velikost sachovnice, souradnice startovniho a 
	ciloveho pole a taky seznam zakazanych poli. 
	
	Vystup mel byt proveden alespon jednoduse graficky. Osobne jsem ho 
 	pojal dost minimalisticky :) 

	Martin Ziegler }

program Strelec;

uses Crt;

const MaxM = 20; { Maximalni pocet radku. }
const MaxN = 20; { Maximalni pocet sloupcu. }
	
type 
	
  Pole = record
    m,n : integer;
  end;	  
  
var

  { Pocet radku, sloupcu. }
  M, N : integer; 

  { Startovni a cilove pole. }
  Start, Cil : Pole;

  { -1 ~ Pole je zakazane. }
  {  0 ~ Pole je volne, ale jeste jsme ho nenavstivili. }
  {  1 ~ Pole uz jsme navstivili. }
  {  2 ~ Pouziva se az na zaver a znamena, ze pole je soucasti hledane cesty. }
  Sachovnice : array [1..MaxM, 1..MaxN] of integer;

  { Dalsi[p] uklada pole, ktere nasleduje za polem 'p' v ceste smerem k cili. }
  Dalsi : array [1..MaxM, 1..MaxN] of Pole;
  
  { Fronta poli k prozkoumani. }
  Fronta : array [1..MaxM*MaxN] of Pole;
  FrontaW, FrontaR : integer;

  { Holky pro vsechno. }
  i, j, k, l : integer;
  x, y : Pole;

{ ===================================================================================== }
{ ===================================================================================== }
{ ===================================================================================== }

procedure Nacti;
var
  Soubor : text;

begin
  Assign(Soubor, 'Vstup.txt');
  Reset(Soubor);

  ReadLn(Soubor, M, N);
	for i := 1 to M do
    for j := 1 to N do Sachovnice[i,j] := 0;

  ReadLn(Soubor, Start.m, Start.n);
  ReadLn(Soubor, Cil.m, Cil.n);
  Sachovnice[Cil.m, Cil.n] := 1;

  ReadLn(Soubor, j);
  for i := 1 to j do
  begin
    ReadLn(Soubor, k, l);
    Sachovnice[k, l] := -1;
  end;

  Close(Soubor);
end;

{ ===================================================================================== }

procedure VypisSachovnici;
begin
  for i := 1 to N+2 do Write('-');
  WriteLn;

  for i := 1 to M do
  begin
    Write('I');
    for j := 1 to N do
    begin
      if (i=Start.m) and (j=Start.n) then Write('S') else
      if (i=Cil.m)   and (j=Cil.n)   then Write('C') else
      if Sachovnice[i,j] = -1 then Write('X') else
      if Sachovnice[i,j] =  2 then Write('*') else
      Write(' ');
    end;
    WriteLn('I');
  end;

  for i := 1 to N+2 do Write('-');
end;

{ ===================================================================================== }

{ Jako parametry bere pole 'p' a smer pohybu strelce, ktery se ma prozkoumat. 
	Za odmenu pak prozkouma vsechny pole danym smerem od pole 'p' a pokud jeste nebyla
	prozkoumana, zaradi je do fronty. }

procedure BFS_Krok ( p : Pole; Doleva, Nahoru : boolean );
var
  PuvodniPole : Pole;

begin
  PuvodniPole := p;

  while True do
  begin
    if Doleva then Dec(p.n) else Inc(p.n);
    if Nahoru then Dec(p.m) else Inc(p.m);

    if (p.m <= 0) or (p.m > M) or (p.n <= 0) or (p.n > N) then exit;

    if Sachovnice[p.m, p.n] = -1 then exit;

    if Sachovnice[p.m, p.n] = 0 then
    begin
      Fronta[FrontaW] := p; Inc(FrontaW);
      Sachovnice[p.m, p.n] := 1;
      Dalsi[p.m, p.n] := PuvodniPole;
    end;
  end;
end;

{ ===================================================================================== }

{ Nastavi pole p1, p2 a vsechny pole mezi nimi v poli Sachovnice na hodnotu '2'.
	Ocekva se, ze p1 a p2 lezi na diagonale. }

procedure VyznacCestu ( p1, p2 : Pole );
var
  p : Pole;

begin
  p := p1;
  Sachovnice[p.m, p.n] := 2;
  repeat
    if (p1.m < p2.m) then Inc(p.m) else Dec(p.m);
    if (p1.n < p2.n) then Inc(p.n) else Dec(p.n);
    Sachovnice[p.m, p.n] := 2;
  until (p.m = p2.m) and (p.n = p2.n);
end;

{ ===================================================================================== }
{ ===================================================================================== }
{ ===================================================================================== }

BEGIN
  ClrScr;

	{ Vstup a jeho kontrola. }
  Nacti;
  if (Start.m - Start.n) mod 2 <> (Cil.m - Cil.n) mod 2 then
  begin
    WriteLn('Startovni a cilove pole jsou ruznych barev => Neexistuje cesta.');
    ReadLn;
    exit;
  end;

	{ Samotne hledani cesty. }
  Fronta[1] := Cil;
  FrontaR := 1; FrontaW := 2;

  while (FrontaR < FrontaW) and (Sachovnice[Start.m, Start.n] <> 1) do
  begin
    x := Fronta[FrontaR]; Inc(FrontaR);
    BFS_Krok(x, True, True);
    BFS_Krok(x, True, False);
    BFS_Krok(x, False, False);
    BFS_Krok(x, False, True);
  end;

	{ Vystup. Pokud jsme nasli cestu: }
  if Sachovnice[Start.m, Start.n] = 1 then
  begin
    x := Start;
    repeat
      VyznacCestu(x, Dalsi[x.m, x.n]);
      x := Dalsi[x.m, x.n];
    until (x.m = Cil.m) and (x.n = Cil.n);
    VypisSachovnici;
  end

	{ A pokud jsme ji tak uplne nenasli: }
  else
  begin
    WriteLn('Cesta neexistuje.');
  end;

  ReadLn;
END.
