{ Generator fraktalu }
{ Petr Cecil }
{ I/1-X/31 }
{ zimni semestr 2006/7 }
{ Programovani PRG001 }

{$mode objfpc}
program fraktaly;
uses
   GL, GLU, GLUT;

const
   N=900000; //maximalni velikost pole/pocet iteraci

type
   pxmap = array[1..N, 1..3] of double; //pixmapa

var
   maxi, i: Integer; //promenne pouzivane v iteracich
   frame:integer=0; cas:integer=0; cas2:integer=0; //pocitadlo framu
   jmeno,fps: string; //stringy pro vypis textu do OpenGL
   xposun:double=0.2; yposun:double=1; zposun:double=-1.7;  //umisteni fraktalu v prostoru
   x, y, z, xn, yn, zn: double; //promenne pro urceni souradnic jednotlivych pixelu dynamickych systemu fraktalu
   a:double=2; b:double=2; c:double=-1; d:double=0; //parametry dynamickych systemu fraktalu
   fractal:byte=1; //druh fraktalu
   matrix:pxmap; //pixmapa do ktere ukladam vygenerovane souradnice pixelu

function sgn(x: double): double; //fce sgn
begin
   if x > 0 then sgn:=1
   else if x < 0 then sgn:=-1
   else sgn:=0;
end;

function log(X, base: double): double; //logaritmus s realnym zakladem
begin
	 log := ln(X) / ln(base);
end;

procedure glPrint(text: string); //vypis textu do OpenGL okna pomoci rastrovych pisem
var c: integer;
begin
  glColor3f(1, 1, 1);
  glRasterPos2f(0 , 0);
  for c:=1 to length(text) do glutBitmapCharacter(GLUT_BITMAP_8_BY_13, ord(text[c]));
end;

procedure DisplayWindow; cdecl; //zakladni fce pro vykresleni okna
var cislo: string;

begin
  glClearColor(0, 0, 0.2, 1);
  glClear(GL_COLOR_BUFFER_BIT+GL_DEPTH_BUFFER_BIT);

  glPushMatrix;

  glTranslatef(-1.2, 0.9, -1.0);
  glPrint(jmeno);
  glTranslatef(1.2, -0.9, 1.0);

  //pocitadlo snimku
  inc(frame);
  cas:=glutGet(GLUT_ELAPSED_TIME);
  if (cas-cas2) > 1000 then
  begin
   str((frame*1000/(cas-cas2)):5:3,fps);
   cas2:=cas;
   frame:=0;
  end;
  glTranslatef(1, 0.9, -1.0);
  glPrint('FPS:'+fps);
  glTranslatef(-1, -0.9, 1.0);

  glTranslatef(-1.2, -0.85, -1.0);
  str(a:5:3,cislo);
  glPrint('PgUp/Dwn - parametr a='+cislo);
  glTranslatef(0, -0.1, 0);
  str(b:5:3,cislo);
  glPrint('Home/End - parametr b='+cislo);
  glTranslatef(1.2, 0.9, 1.0);
  glTranslatef(xposun, yposun, zposun); //zpracujeme posun

  //vykreslime pixmapu
  for i:=1 to maxi do
  begin
   glBegin(GL_POINTS);
   if matrix[i,3]=0 then
    glColor3f(matrix[i,1]/15.0+i/maxi , matrix[i,2]/10.0+i/maxi/2.0, matrix[i,1]/10.0)
   else
    glColor3f(matrix[i,1]+1.3, matrix[i,2]+1.3, matrix[i,3]+1.3);
   glVertex3f( matrix[i,1], matrix[i,2], matrix[i,3]);
   glEnd();
  end;
  glTranslatef(-xposun, -yposun, -zposun);

  glPopMatrix;

  glutSwapBuffers;
end;

procedure generatefractal; cdecl; //generator dynamickeho systemu (spousti se vzdy jen jednou)
begin
for i:=0 to maxi do //vygumujeme si pixmapu
begin
 matrix[i,1]:=0; matrix[i,2]:=0; matrix[i,3]:=0;
end;

case fractal of //seznam dynamickych systemu
  2: begin
   jmeno:='Lorenzuv atraktor'; //nazev
   x:=0.0; y:=0.5; z:=0.2; //pocatecni parametry
   maxi:=10000;
   for i:=0 to maxi do //iterujeme
    begin
    xn:=x+(-a*x*d)+(a*y*d);
    yn:=y+(b*x*d)-(y*d)-(z*x*d);
    zn:=z+(-c*z*d)+(x*y*d);
    x:=xn; y:=yn; z:=zn;
    matrix[i,1]:=x; matrix[i,2]:=y; matrix[i,3]:=z; //ulozime si vysledky do pixmapy
    end;
   end;
  3: begin
   jmeno:='Latoocarfian';//stejne jako vyse
   x:=0.1; y:=0.1; z:=0;
   maxi:=100000;
   for i:=0 to maxi do
    begin
    xn:=sin(b*y)+c*sin(x*b);
    yn:=sin(a*x)+d*sin(y*a);
    x:=xn; y:=yn;
    matrix[i,1]:=x; matrix[i,2]:=y; matrix[i,3]:=z;
    end;
   end;
    4: begin
   jmeno:='Martin';
   x:=0.1; y:=0; z:=0;
   maxi:=59000;
   for i:=maxi downto 0 do
    begin
    xn:=y-sin(x);
    yn:=a/100+3.14-x;
    x:=xn; y:=yn;
    matrix[i,1]:=x; matrix[i,2]:=y; matrix[i,3]:=z;
    end;
   end;
    5: begin
   jmeno:='Gingerbreadman';
   x:=-0.1; y:=0; z:=0;
   maxi:=30000;
   for i:=0 to maxi do
    begin
    xn:=1.0-y+abs(x);
    yn:=x;
    x:=xn; y:=yn;
    matrix[i,1]:=x; matrix[i,2]:=y; matrix[i,3]:=z;
    end;
   end;
    6: begin
   jmeno:='Rossleruv atraktor';
   x:=0; y:=0; z:=0;
   for i:=0 to 53000 do
    begin
    xn:=x-y*d-z*d;
    yn:=y+x*d+a*y*d;
    zn:=z+b*d+x*z*d-c*z*d;
    x:=xn; y:=yn; z:=zn;
    matrix[i,1]:=x; matrix[i,2]:=y; matrix[i,3]:=z;
    end;
   end;
    7: begin
   jmeno:='Hopalong';
   x:=0.0; y:=0.05; z:=0;
   maxi:=30000;
   for i:=0 to maxi do
    begin
    if x > 0 then xn:= y - sqrt (abs (b * x - c))
    else xn:= y + sqrt (abs (b * x - c));
    yn:= a - x;
    x:=xn; y:=yn;
    matrix[i,1]:=x; matrix[i,2]:=y; matrix[i,3]:=z;
    end;
   end;
    8: begin
   jmeno:='Pickover';
   x:=0; y:=0;
   maxi:=10000;
   for i:=0 to maxi do
    begin
    xn:=sin(a*y)-z*cos(b*x);
    yn:=z*sin(c*x)-cos(d*y);
    zn:=sin(x);
    x:=xn; y:=yn; z:=zn;
    matrix[i,1]:=x; matrix[i,2]:=y; matrix[i,3]:=z;
    end;
   end
  else
   jmeno:='Podivny atraktor';
   maxi:=10000;
   for i:=0 to maxi do
    begin
    zn:=sin(x);
    xn:=sin(a*y)-z*cos(b*x);
    yn:=z*sin(c*x)-cos(d*y);
    x:=xn; y:=yn; z:=zn;
    matrix[i,1]:=x; matrix[i,2]:=y; matrix[i,3]:=z;
   end;
  end;

end;

procedure OnTimer(value: Integer); cdecl;
begin
  glutPostRedisplay;
  glutTimerFunc(20, @OnTimer, 0);
end;

procedure key(k:byte;x,y:longint); cdecl; //fce pro cteni klaves pomoci opengl okna
begin
  case k of
     27: halt(0); //konec
     114: generatefractal; //prekresli fraktal
  end;
end;

procedure speckey(k:integer;x,y:longint); cdecl; //dalsi fce pro cteni klaves pomoci opengl okna
var ctrl: integer;
begin
ctrl:=glutGetModifiers();
case k of
     GLUT_KEY_LEFT: xposun:=xposun-0.2; //posuny
     GLUT_KEY_RIGHT: xposun:=xposun+0.2;
     GLUT_KEY_UP: if ctrl=GLUT_ACTIVE_CTRL then zposun:=zposun+0.2 else yposun:=yposun+0.2; //zoom a posun
     GLUT_KEY_DOWN:  if ctrl=GLUT_ACTIVE_CTRL then zposun:=zposun-0.2 else yposun:=yposun-0.2;
     GLUT_KEY_F1: begin fractal:=1; xposun:=0.2; yposun:=1; zposun:=-1.7; a:=2; b:=2; c:=-1; d:=0; end; //vyber fraktalu
     GLUT_KEY_F2: begin fractal:=2; xposun:=-1; yposun:=-2; zposun:=-60; a:=3.0; b:=26.5; c:=1.0; d:=0.01; end;
     GLUT_KEY_F3: begin fractal:=3; xposun:=0; yposun:=0; zposun:=-1.2; a:=-0.966; b:=2.879; c:=0.765; d:=0.744; end;
     GLUT_KEY_F4: begin fractal:=4; xposun:=0; yposun:=-1; zposun:=-57; a:=3.14; end;
     GLUT_KEY_F5: begin fractal:=5; xposun:=0; yposun:=-1; zposun:=-7; end;
     GLUT_KEY_F6: begin fractal:=6; xposun:=0; yposun:=0; zposun:=-30; a:=0.2; b:=0.2; c:=5.7; d:=0.04; end;
     GLUT_KEY_F7: begin fractal:=7; xposun:=0; yposun:=-0.5; zposun:=-2; a:=0.4; b:=1.0; c:=0.0; end;
     GLUT_KEY_F8: begin fractal:=8; xposun:=0.2; yposun:=0; zposun:=-3; a:=1.94; b:=-0.17; c:=-0.65; d:=-2.43; end;
     GLUT_KEY_PAGE_UP: a:=a+0.1; //zmeny parametru fraktalu
     GLUT_KEY_PAGE_DOWN: a:=a-0.1;
     GLUT_KEY_HOME: b:=b+0.1;
     GLUT_KEY_END: b:=b-0.1;
end;
if (k<>GLUT_KEY_LEFT) and (k<>GLUT_KEY_RIGHT) and
(k<>GLUT_KEY_UP) and (k<>GLUT_KEY_DOWN) then generatefractal;  //negeneruj znova fraktal pri posunuti
end;

begin
  glutInit(@argc, argv);
  glutInitDisplayMode(GLUT_RGB or GLUT_DOUBLE or GLUT_DEPTH);
  glutInitWindowSize(800,600);
  glutCreateWindow('Fraktaly');
  glutKeyboardFunc(@key);
  glutSpecialFunc(@speckey);
  glutDisplayFunc(@DisplayWindow);
  glutTimerFunc(20, @OnTimer, 0);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  gluPerspective(90, 1.3, 0.1, 100);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity;
  WriteLn('Spoustim okno...');
  generatefractal;
  glutMainLoop;

end.
